// conduit pipe and fittings
// m.miller 04.14.23


#include "conduit_pipe/conduit_pipe_materials.inc"


// -----------------------------------------------------------------------------------------
//                       P A R T S
//------------------------------------------------------------------------------------------


//---screw head
#declare screw_head = 
difference {
    union {
    sphere{ <0,0,0>, 1 }
    cylinder {<0,0,0>,<0,0,1>,1}
    }
    box { <-2,-.15,-.55> , <2,.15,-2> translate <-0.000, 0, 0.000> }  
    box { <-.15,2,-.55> , <.15,-2,-2> translate <-0.000, 0, 0.000> } 
    scale <1,1,.5> 
    translate <0,0,-.5>
    material{M_galvanize}
}


//--- sweep for strap body
#declare strap_sweep = 
#declare sf = .7;
sphere_sweep {
     cubic_spline
     13,
     <-6.123, 0.000, -4.910> , sf
     <-6.123, 0.000, -4.910> , sf
     <-5.367, 0.000, 0.004> , sf
     <-4.551, 0.000, 2.942> , sf
     <-2.622, 0.000, 4.758> , sf
     <-0.003, 0.000, 5.402> , sf
     <2.582, 0.000, 4.722> , sf
     <4.578, 0.000, 2.930> , sf
     <5.417, 0.000, -0.017> , sf
     <5.417, 0.000, -3.503> , sf
     <6.338, 0.000, -4.603> , sf
     <16.014, 0.000, -4.603> , sf
     <16.014, 0.000, -4.603> , sf
     tolerance 0.000001   
     rotate <180,0,0> 
     scale <.2,.2,.2>
     }  

     
 //---pipe    
#macro make_pipe(len,rad) 
    union{
       cylinder { <0,0,0>, <0,len,0>, rad }  // pipe
       material {M_galvanize}
    }
#end


//---flange
#macro make_flange(len,rad)
    union {
        #declare pZ = (rad + rad/4) * -1;
        union {
            cylinder { <0,0,0>, <0,len,0>, rad }
            torus { rad, rad/6  scale <1,.75,1> translate <0,len,0>      }
            torus { rad, rad/6  scale <1,.75,1> translate <0,0,0>        }  
            cylinder { <0,0,0>, <0,len,0>, 1 translate <0,0,-rad>    }
            cylinder { <0,0,0>, <0,len,0>, 1 translate <-rad,0,0>    }
            cylinder { <0,0,0>, <0,len,0>, 1 translate <rad,0,0>     }
            cylinder { <0,0,rad>, <0,0,pZ>, rad/1.8 translate <0,len/2,0>  } 
            material {M_galvanize}   
        } 
        object {screw_head scale <rad/2,rad/2,rad/2> rotate <0,0,0> translate <0,len/2,pZ> }
    }    
#end



//coupling
#macro make_coupling(len,rad)
    union {
        #declare pZ = (rad + rad/4) * -1; 
        #declare pY1 = len/5;     // 1/5
        #declare pY2 = pY1*4;     // 4/5
        
        union {
            cylinder { <0,0,0>, <0,len,0>, rad }
            torus { rad, rad/6  scale <1,.75,1> translate <0,len,0>      }
            torus { rad, rad/6  scale <1,.75,1> translate <0,0,0>        }  
            cylinder { <0,0,0>, <0,len,0>, 1 translate <0,0,-rad>    }
            cylinder { <0,0,0>, <0,len,0>, 1 translate <-rad,0,0>    }
            cylinder { <0,0,0>, <0,len,0>, 1 translate <rad,0,0>     }
            cylinder { <0,0,rad>, <0,0,pZ>, rad/1.8 translate <0,pY1,0>  } 
            cylinder { <0,0,rad>, <0,0,pZ>, rad/1.8 translate <0,pY2,0>  } 
            material {M_galvanize}   
        } 
        object {screw_head scale <rad/2,rad/2,rad/2> rotate <0,0,0> translate <0,pY1,pZ> }   
        object {screw_head scale <rad/2,rad/2,rad/2> rotate <0,0,0> translate <0,pY2,pZ> }
    }    
#end


//---strap
#macro make_strap(len,rad) 
#declare fillet = rad/4;
union {
    union { 
        #difference {
            torus { rad+1, fillet translate <0,0,0> }
            plane { <0,0,-1>, 0 translate <0,0,0> }
        } 
        cylinder { <0,0,0>, <0,0,rad+1>, fillet translate <rad+1,0,0> }
        cylinder { <0,0,0>, <0,0,rad+1>, fillet translate <-rad+1,0,0> }
        
        difference {
        object { strap_sweep scale <rad,rad*8,rad> }
        plane { <0,-1,0>, 0 translate <0,rad,0> }
        plane { <0,1,0>, 0 translate <0,-rad,0> }
        }
        material {M_galvanize}  
    }
    object {screw_head scale <rad/2,rad/2,rad/2> translate <rad*2.5,0,rad-fillet> }
}
#end



//---elbo
#macro make_elbow(rad)
union {
     union {
         difference{
            torus { rad*2,rad rotate<90,0,0>  }
            plane { <-1,0,0>, 0}     
            plane { <0,1,0>, 0} 
            }
         translate < rad*2,0,0>
         material {M_galvanize}
     }
    union {
         cylinder { <0,0,0>, <0,-rad,0>, rad }   
         cylinder { <rad*2,rad*2,0>, <rad*2 + rad,rad*2,0>, rad }
         material {M_galvanize}
    }
}                 
#end 




// -----------------------------------------------------------------------------------------
//                       P I P E    A S S E M B L I E S
//------------------------------------------------------------------------------------------

#declare pipe_rad =     5; 
#declare strap_len =    10; 
#declare flange_len =   20;   
#declare coupling_len = 20; 
#declare pipe_rad =     5; 
#declare pipe_len =     200;



//--- vertical conduit attach to panel box and receptical
#declare conduit_A =
union {
    object { make_pipe(pipe_len,pipe_rad)   }
    object { make_flange(flange_len,pipe_rad+1) translate <0,0,0> } 
    object { make_coupling(coupling_len,pipe_rad+1) translate <0,100,0> } 
    object { make_strap(strap_len,pipe_rad) rotate <0,0,0> translate <0,40,0> }

}


//--- corner conduit attaching to panel box
#declare conduit_B =  
#declare pipe_len = 60; 
#declare pipe_lenB = 160; 
#declare elbow_y = pipe_len+pipe_rad; 
union {
    union {
        object { make_pipe(pipe_len,pipe_rad)   }
        object { make_flange(flange_len,pipe_rad+1) translate <0,0,0> } 
        //object { make_strap(strap_len,pipe_rad) rotate <0,0,180> translate <0,40,0> }
        object { make_elbow(pipe_rad+1.5) rotate <0,90,0> translate <0,elbow_y,0>  }
        rotate <90,0,0> rotate <0,0,-90> 
        }
        union {
        object { make_pipe(pipe_lenB,pipe_rad) }
        object { make_strap(strap_len,pipe_rad) rotate <0,0,0> translate <0,100,0> }  
        object { make_coupling(coupling_len,pipe_rad+1) translate <0,30,0> } 
        rotate <0,0,90> translate <pipe_lenB+(pipe_rad*2),0,elbow_y+((pipe_rad-.75)*3)>
        }
    }